/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.util;

import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import team.chisel.ctm.api.util.NonnullType;
import team.chisel.ctm.client.util.CTMLogic;
import team.chisel.ctm.client.util.DirectionHelper;

@ParametersAreNonnullByDefault
public enum Dir {
    TOP(Direction.UP),
    TOP_RIGHT(Direction.UP, Direction.EAST),
    RIGHT(Direction.EAST),
    BOTTOM_RIGHT(Direction.DOWN, Direction.EAST),
    BOTTOM(Direction.DOWN),
    BOTTOM_LEFT(Direction.DOWN, Direction.WEST),
    LEFT(Direction.WEST),
    TOP_LEFT(Direction.UP, Direction.WEST);

    public static final Dir[] VALUES;
    private static final Direction NORMAL;
    @NonnullType
    private Direction[] dirs;
    @NonnullType
    private BlockPos[] offsets = new BlockPos[6];

    private Dir(Direction ... dirs) {
        this.dirs = dirs;
    }

    private void buildCaches() {
        for (Direction normal : Direction.values()) {
            BlockPos ret;
            Direction[] normalized;
            if (normal == NORMAL) {
                normalized = this.dirs;
            } else if (normal == NORMAL.m_122424_()) {
                ret = new Direction[this.dirs.length];
                for (int i = 0; i < ((Direction[])ret).length; ++i) {
                    ret[i] = this.dirs[i].m_122430_() != 0 ? this.dirs[i] : this.dirs[i].m_122424_();
                }
                normalized = ret;
            } else {
                Direction axis = normal.m_122430_() == 0 ? (normal == NORMAL.m_122427_() ? Direction.UP : Direction.DOWN) : (normal == Direction.UP ? NORMAL.m_122428_() : NORMAL.m_122427_());
                Direction[] ret2 = new Direction[this.dirs.length];
                for (int i = 0; i < ret2.length; ++i) {
                    ret2[i] = this.rotate(this.dirs[i], axis);
                }
                normalized = ret2;
            }
            ret = BlockPos.f_121853_;
            for (Direction dir : normalized) {
                ret = ret.m_142300_(dir);
            }
            this.offsets[normal.ordinal()] = ret;
        }
    }

    public boolean isConnected(CTMLogic ctm, BlockGetter world, BlockPos pos, Direction side) {
        return ctm.isConnected(world, pos, this.applyConnection(pos, side), side);
    }

    public boolean isConnected(CTMLogic ctm, BlockGetter world, BlockPos pos, Direction side, BlockState state) {
        return ctm.isConnected(world, pos, this.applyConnection(pos, side), side, state);
    }

    @Nonnull
    public BlockPos applyConnection(BlockPos pos, Direction side) {
        return pos.m_141952_((Vec3i)this.getOffset(side));
    }

    public Dir relativize(Direction normal) {
        throw new UnsupportedOperationException("Yell at tterrag to finish deserialization");
    }

    @Nonnull
    public BlockPos getOffset(Direction normal) {
        return this.offsets[normal.ordinal()];
    }

    @Nullable
    public Dir getDirFor(Direction[] dirs) {
        if (dirs == this.dirs) {
            return this;
        }
        for (Dir dir : VALUES) {
            if (!Arrays.equals(dir.dirs, dirs)) continue;
            return dir;
        }
        return null;
    }

    private Direction rotate(Direction facing, Direction axisFacing) {
        Direction.Axis axis = axisFacing.m_122434_();
        Direction.AxisDirection axisDir = axisFacing.m_122421_();
        if (axisDir == Direction.AxisDirection.POSITIVE) {
            return DirectionHelper.rotateAround(facing, axis);
        }
        if (facing.m_122434_() != axis) {
            switch (axis) {
                case X: {
                    switch (facing) {
                        case NORTH: {
                            return Direction.UP;
                        }
                        case DOWN: {
                            return Direction.NORTH;
                        }
                        case SOUTH: {
                            return Direction.DOWN;
                        }
                        case UP: {
                            return Direction.SOUTH;
                        }
                    }
                    return facing;
                }
                case Y: {
                    return facing.m_122428_();
                }
                case Z: {
                    switch (facing) {
                        case EAST: {
                            return Direction.EAST;
                        }
                        case WEST: {
                            return Direction.WEST;
                        }
                        case UP: {
                            return Direction.DOWN;
                        }
                        case DOWN: {
                            return Direction.UP;
                        }
                    }
                    return facing;
                }
            }
        }
        return facing;
    }

    static {
        VALUES = Dir.values();
        NORMAL = Direction.SOUTH;
        for (Dir dir : VALUES) {
            dir.buildCaches();
        }
    }
}

